#include <gl/glut.h>
#include <math.h>

#define PI 3.1415192535897

void kirajzol(void);
void init(void);

void main()
	{
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);	// megjelentsi md
	glutInitWindowSize(500,500);						// ablakmret
	init();
	glutCreateWindow("Elso OpenGL pelda - 'Korrajzolas'");	// ablak ltrehozsa
	glutDisplayFunc(kirajzol);							// a rajzol fuggvny megadsa
	glutMainLoop();										// vgtelen ciklus a rajzolshoz
	}

float *kor;
int points = 100;

void init()
	{	
	kor = new float [points * 3];
	
	for (int i = 0,j = 0; i < points; i++)
		{
		float szog = 2 * PI * i / points;
		kor[j] = cos(szog); 
		kor[j+1] = sin(szog);
		j+=2;
		} 
	}

void kirajzol(void) 
	{
	glClearColor (0.5f, 0.5f, 0.5f, 0.0f);	
	glClear (GL_COLOR_BUFFER_BIT);	

	glVertexPointer(2, GL_FLOAT, 0, kor);	// tmb struktra megadsa 

	glEnableClientState(GL_VERTEX_ARRAY);	// a vertex array hasznlhat

	glDrawArrays(GL_LINE_LOOP, 0, points); // kirajzols
	
	glFlush();
	}

